-------------------------------------------------------
-- Created by Ben Cope of Imperial College (June 2005)
-- Constants and types for Filter  2x2
-------------------------------------------------------

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;
USE IEEE.std_logic_arith.ALL;

PACKAGE Constants IS

 CONSTANT RGB_width : INTEGER := 8;	
 CONSTANT n : INTEGER := 2;
 CONSTANT image_dim: INTEGER := 512;
 CONSTANT log_image_dim: INTEGER := 9;
 
 TYPE Vector_integer IS ARRAY (0 TO n-1) OF INTEGER;
 TYPE Array_integer IS ARRAY (0 TO n-1) OF Vector_integer;

 SUBTYPE RGB_type IS STD_LOGIC_VECTOR(RGB_width-1 DOWNTO 0);
 TYPE VectorRGB IS ARRAY (0 TO 2) OF RGB_type;

  TYPE CHANNEL_TYPE IS RECORD
      RGB : VectorRGB;
		Valid : STD_LOGIC;
 END RECORD;

 TYPE Channel_1xn IS ARRAY (0 TO n-1) OF CHANNEL_TYPE;
 TYPE Channel_nxn IS ARRAY (0 TO n-1) OF Channel_1xn;
 
 TYPE VectorRGB_1xdim IS ARRAY (0 TO image_dim-1) OF VectorRGB;
 TYPE VectorRGB_nxdim IS ARRAY (0 TO n-1) OF VectorRGB_1xdim;

 SUBTYPE Res_type IS STD_LOGIC_VECTOR(RGB_width*2-1 DOWNTO 0);
 TYPE VectorRes IS ARRAY (0 TO 2) OF Res_type;
 TYPE VectorRes_1xn IS ARRAY (0 TO n-1) OF VectorRes;
 TYPE VectorRes_nxn IS ARRAY (0 TO n-1) OF VectorRes_1xn;

 SUBTYPE RGB_ex IS STD_LOGIC_VECTOR(RGB_width DOWNTO 0);
 TYPE VectorRGB_ex IS ARRAY (0 TO 2) OF RGB_ex;
 TYPE VectorRGB_ex_1xn IS ARRAY (0 TO n-1) OF VectorRGB_ex;
 TYPE VectorRGB_ex_nxn IS ARRAY (0 TO n-1) OF VectorRGB_ex_1xn;

 TYPE BIT_ARRAY_8x3 IS ARRAY (0 TO 7) OF STD_LOGIC_VECTOR(0 TO 2);
TYPE BIT_ARRAY_4x3 IS ARRAY (0 TO 3) OF STD_LOGIC_VECTOR(0 TO 2);
TYPE BIT_ARRAY_2x3 IS ARRAY (0 TO 1) OF STD_LOGIC_VECTOR(0 TO 2);

 TYPE VectorMx_1xn IS ARRAY (0 TO n-1) OF RGB_ex;
 TYPE VectorMx_nxn IS ARRAY (0 TO n-1) OF VectorMx_1xn;

-- CONSTANT matrix: VectorMx_nxn :=
-- (("000000000", "000000000"),
--  ("000000000", "000000000"));
  
 CONSTANT matrix: VectorMx_nxn :=
 (("011101010", "010101101"),
  ("011101010", "010101101"));    

 CONSTANT clock_period : TIME := 2 ns;

END Constants;
